/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.tree;

import com.ibm.hwmca.fw.util.tree.SelectionTreeListener;
import com.ibm.hwmca.fw.util.tree.SimpleTreeEvent;
import com.ibm.hwmca.fw.util.tree.SimpleTreeNode;
import java.util.ArrayList;
import java.util.List;

public class SelectionTreeNode
extends SimpleTreeNode {
    private boolean selected;
    private transient ArrayList selectionListeners;

    public SelectionTreeNode() {
        this(false, null);
    }

    public SelectionTreeNode(Object userObject) {
        this(false, userObject);
    }

    public SelectionTreeNode(boolean selected) {
        this(selected, null);
    }

    public SelectionTreeNode(boolean selected, Object userObject) {
        super(userObject);
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            if (selected) {
                this.sendSelectedEvent(this);
            } else {
                this.sendDeselectedEvent(this);
            }
        }
    }

    public void unselectAll() {
        this.setSelected(false);
        if (this.children != null) {
            int size = this.children.size();
            int i = 0;
            while (i < size) {
                SelectionTreeNode node = (SelectionTreeNode)this.children.get(i);
                node.setSelected(false);
                node.unselectAll();
                ++i;
            }
        }
    }

    public boolean add(SelectionTreeNode child) {
        return super.add(child);
    }

    public boolean add(SimpleTreeNode child) {
        return false;
    }

    public boolean add(List children) {
        boolean result = false;
        int size = children.size();
        int i = 0;
        while (i < size) {
            Object child = children.get(i);
            if (child instanceof SelectionTreeNode) {
                if (result) {
                    super.add((SelectionTreeNode)child);
                } else {
                    result = super.add((SelectionTreeNode)child);
                }
            }
            ++i;
        }
        return result;
    }

    public List getSelectedNodes() {
        return this.getSelectedNodes((SelectionTreeNode)this.getRoot(), new ArrayList());
    }

    public List getSelectedNodes(SelectionTreeNode parent, List selectedNodes) {
        if (parent.isSelected()) {
            selectedNodes.add(parent);
        }
        if (parent.hasChildren()) {
            int size = parent.children.size();
            int i = 0;
            while (i < size) {
                this.getSelectedNodes((SelectionTreeNode)parent.children.get(i), selectedNodes);
                ++i;
            }
        }
        return selectedNodes;
    }

    public List getSelectedLeafNodes() {
        return this.getSelectedLeafNodes((SelectionTreeNode)this.getRoot(), new ArrayList());
    }

    public List getSelectedLeafNodes(SelectionTreeNode node, List leafNodes) {
        if (node.isLeaf() && node.isSelected()) {
            leafNodes.add(node);
        }
        if (node.hasChildren()) {
            int size = node.children.size();
            int i = 0;
            while (i < size) {
                this.getSelectedLeafNodes((SelectionTreeNode)node.children.get(i), leafNodes);
                ++i;
            }
        }
        return leafNodes;
    }

    public List getFirstSelectedNodesForUserObject(Object userObject) {
        ArrayList<SelectionTreeNode> result = new ArrayList<SelectionTreeNode>();
        List nodes = this.getNodesForUserObject(userObject);
        int size = nodes.size();
        int i = 0;
        while (i < size) {
            result.add(this.getFirstSelectionForNode((SelectionTreeNode)nodes.get(i)));
            ++i;
        }
        return result;
    }

    protected SelectionTreeNode getFirstSelectionForNode(SelectionTreeNode node) {
        if (node.isSelected()) {
            return node;
        }
        if (!node.isRoot()) {
            return this.getFirstSelectionForNode((SelectionTreeNode)node.getParent());
        }
        return null;
    }

    public void addSelectionListener(SelectionTreeListener listener) {
        this.getSelectionListeners().add(listener);
    }

    private List getSelectionListeners() {
        SelectionTreeNode root = (SelectionTreeNode)this.getRoot();
        if (root.selectionListeners == null) {
            root.selectionListeners = new ArrayList();
        }
        return root.selectionListeners;
    }

    private void sendSelectedEvent(SelectionTreeNode child) {
        SimpleTreeEvent evt = new SimpleTreeEvent(this, child);
        this.sendEvent(true, evt);
    }

    private void sendDeselectedEvent(SelectionTreeNode child) {
        SimpleTreeEvent evt = new SimpleTreeEvent(this, child);
        this.sendEvent(false, evt);
    }

    private synchronized void sendEvent(boolean eventType, SimpleTreeEvent evt) {
        List listeners = this.getSelectionListeners();
        int size = listeners.size();
        int i = 0;
        while (i < size) {
            SelectionTreeListener listener = (SelectionTreeListener)listeners.get(i);
            if (eventType) {
                listener.treeNodeSelected(evt);
            } else {
                listener.treeNodeDeselected(evt);
            }
            ++i;
        }
    }

    public String toString() {
        return super.toString() + ",selected=" + this.selected;
    }
}

